<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Traits;

trait TraitStringMapDTO
{
    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string[] 
     */
    private $entries = array();

    /*
    |--------------------------------------------------------------------------
    | constructor without promoted properties, helps static analysis
    |--------------------------------------------------------------------------
    */

    /**
     * @param string[] $entires 
     */
    public function __construct($entires = array())
    {
        foreach ($entires as $itemKey => $itemValue)
        {
            $this -> add($itemKey, $itemValue);
        }
    }

    /*
    |--------------------------------------------------------------------------
    | from json map
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return new static($data);
    }

    /*
    |--------------------------------------------------------------------------
    | interface
    |--------------------------------------------------------------------------
    */

    public function containsKey(string $key): bool
    {
        return isset($this -> entries[$key]);
    }

    public function containsValue(string $value): bool
    {
        return \in_array($value, \array_values($this -> entries));
    }

    public function add(string $key, string $value): void
    {
        $this -> entries[$key] = $value;
    }

    public function getValue(string $key, string $fallbackValue = ''): string
    {
        return $this -> entries[$key] ?? $fallbackValue;
    }

    public function updateValue(string $key, string $value): void
    {
        $this -> entries[$key] = $value;
    }

    public function getLength(): int
    {
        return \count($this -> entries);
    }

    public function isEmpty(): bool
    {
        return $this -> getLength() > 0;
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return $this -> entries;
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    /**
     * @param object $stringMapDTO  
     */
    public static function serialize($stringMapDTO): string
    {
        return \json_encode($stringMapDTO);
    }

    /**
     * @return static 
     */
    public static function deSerialize(string $stringMapDTO)
    {
        $data = \json_decode($stringMapDTO, true);

        return static::fromJsonMap($data);
    }
}
